//Code Llama-13B DATASET v1.0 Category: Matrix operations ; Style: synchronous
/*
 *  Unique C Matrix Operations Example Program in Synchronous Style
 *
 *  This program demonstrates some unique matrix operations using C.
 */

#include <stdio.h>

#define N 3

// Function to add two matrices
void add(int A[N][N], int B[N][N], int C[N][N]) {
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            C[i][j] = A[i][j] + B[i][j];
        }
    }
}

// Function to subtract two matrices
void sub(int A[N][N], int B[N][N], int C[N][N]) {
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            C[i][j] = A[i][j] - B[i][j];
        }
    }
}

// Function to multiply two matrices
void mul(int A[N][N], int B[N][N], int C[N][N]) {
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            C[i][j] = A[i][j] * B[i][j];
        }
    }
}

// Function to transpose a matrix
void transpose(int A[N][N], int B[N][N]) {
    for (int i = 0; i < N; i++) {
        for (int j = 0; j < N; j++) {
            B[i][j] = A[j][i];
        }
    }
}

int main() {
    int A[N][N] = {
        {1, 2, 3},
        {4, 5, 6},
        {7, 8, 9}
    };

    int B[N][N] = {
        {1, 2, 3},
        {4, 5, 6},
        {7, 8, 9}
    };

    int C[N][N];

    // Add two matrices
    add(A, B, C);

    // Subtract two matrices
    sub(A, B, C);

    // Multiply two matrices
    mul(A, B, C);

    // Transpose a matrix
    transpose(A, B);

    return 0;
}