//GPT-4o-mini DATASET v1.0 Category: Haunted House Simulator ; Style: asynchronous
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <unistd.h>
#include <time.h>

#define NUM_ROOMS 5
#define NUM_GHOSTS 3

// Room structure
typedef struct {
    int room_id;
    int has_ghost;
    int item_found;
} Room;

// Function prototypes
void* explore_room(void* arg);
void encounter_ghost(int room_id);
void find_item(int room_id);

// Global variable for rooms
Room rooms[NUM_ROOMS];

// Main function
int main() {
    srand(time(NULL));

    // Initialize rooms
    for (int i = 0; i < NUM_ROOMS; i++) {
        rooms[i].room_id = i;
        rooms[i].has_ghost = rand() % 2;  // Randomly generate if the room has a ghost
        rooms[i].item_found = 0;
    }

    // Create room exploration threads
    pthread_t threads[NUM_ROOMS];
    for (int i = 0; i < NUM_ROOMS; i++) {
        if (pthread_create(&threads[i], NULL, explore_room, (void*)&rooms[i]) != 0) {
            perror("Failed to create thread");
            return 1;
        }
    }

    // Join threads
    for (int i = 0; i < NUM_ROOMS; i++) {
        pthread_join(threads[i], NULL);
    }

    printf("All rooms explored!\n");
    return 0;
}

// Function to simulate exploring a room
void* explore_room(void* arg) {
    Room* room = (Room*)arg;

    printf("Exploring room %d...\n", room->room_id);
    sleep(1);  // Simulate time taken to explore the room

    // Randomly decide if an item is found
    if (rand() % 2) {
        find_item(room->room_id);
    }

    // Check for ghost encounter
    if (room->has_ghost) {
        encounter_ghost(room->room_id);
    } else {
        printf("No ghost in room %d. You are safe!\n", room->room_id);
    }

    pthread_exit(NULL);
}

// Function to simulate finding an item
void find_item(int room_id) {
    printf("You found a mysterious item in room %d!\n", room_id);
    // Mark the item as found
    rooms[room_id].item_found = 1;
}

// Function to simulate encountering a ghost
void encounter_ghost(int room_id) {
    printf("A ghost appears in room %d! Run away!\n", room_id);
    // Simulate a ghost encounter
    sleep(1);
    printf("You escaped the ghost in room %d!\n", room_id);
}