//Falcon-180B DATASET v1.0 Category: Memory management ; Style: multiplayer
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PLAYERS 10
#define MAX_NAME_LEN 20

typedef struct {
    char name[MAX_NAME_LEN];
    int score;
} Player;

Player players[MAX_PLAYERS];
int num_players;

void init_players() {
    num_players = 0;
    for (int i = 0; i < MAX_PLAYERS; i++) {
        strcpy(players[i].name, "Player");
        players[i].score = 0;
    }
}

void add_player(char* name) {
    if (num_players >= MAX_PLAYERS) {
        printf("Cannot add more players!\n");
        return;
    }
    strcpy(players[num_players].name, name);
    players[num_players].score = 0;
    num_players++;
}

void remove_player(int index) {
    if (index < 0 || index >= num_players) {
        printf("Invalid player index!\n");
        return;
    }
    num_players--;
    for (int i = index; i < num_players; i++) {
        strcpy(players[i].name, players[i+1].name);
        players[i].score = players[i+1].score;
    }
}

void display_players() {
    printf("Players:\n");
    for (int i = 0; i < num_players; i++) {
        printf("%s - Score: %d\n", players[i].name, players[i].score);
    }
}

int main() {
    init_players();
    add_player("Alice");
    add_player("Bob");
    display_players();
    remove_player(1);
    display_players();
    return 0;
}