//Gemma-7B DATASET v1.0 Category: Elevator Simulation ; Style: single-threaded
#include <stdio.h>
#include <time.h>

#define MAX_FLOORS 10

typedef struct Elevator {
  int currentFloor;
  int targetFloor;
  int passengers;
  int direction;
} Elevator;

Elevator elevator;

void simulateElevator() {
  time_t tStart = time(NULL);

  // Move the elevator to the target floor
  while (elevator.currentFloor != elevator.targetFloor) {
    int currentFloor = elevator.currentFloor;
    elevator.currentFloor += elevator.direction;

    // Simulate time spent on each floor
    sleep(1);

    // Print the elevator's location
    printf("Elevator on floor %d\n", elevator.currentFloor);
  }

  // Door opens
  printf("Elevator door opens on floor %d\n", elevator.targetFloor);

  // Simulate time spent opening the door
  sleep(2);

  // Reset the elevator
  elevator.currentFloor = 1;
  elevator.targetFloor = 0;
  elevator.passengers = 0;
  elevator.direction = 0;
}

int main() {
  // Initialize the elevator
  elevator.currentFloor = 1;
  elevator.targetFloor = 5;
  elevator.passengers = 2;
  elevator.direction = 1;

  // Simulate the elevator
  simulateElevator();

  return 0;
}