//Gemma-7B DATASET v1.0 Category: URL Sanitizer ; Style: careful
#include <stdio.h>
#include <ctype.h>
#include <string.h>

#define MAX_URL_LENGTH 255

void sanitize_url(char *url)
{
  char *p = url;
  char *q = url;

  // Remove leading and trailing spaces
  while (isspace(*p))
  {
    p++;
  }
  while (isspace(*q))
  {
    q--;
  }

  // Convert uppercase letters to lowercase
  for (p = q; *p; p++)
  {
    *p = tolower(*p);
  }

  // Remove invalid characters
  for (p = q; *p; p++)
  {
    if (!isalnum(*p) && *p != '-' && *p != '.' && *p != '_')
    {
      *p = '\0';
    }
  }

  // Normalize URL
  char normalized_url[MAX_URL_LENGTH];
  snprintf(normalized_url, MAX_URL_LENGTH, "%s", url);

  // Print sanitized URL
  printf("Sanitized URL: %s\n", normalized_url);
}

int main()
{
  char url[MAX_URL_LENGTH] = "This is a URL with some special characters!$$";

  sanitize_url(url);

  return 0;
}