//Code Llama-13B DATASET v1.0 Category: Matrix operations ; Style: safe
#include <stdio.h>
    #include <stdlib.h>
    #include <string.h>

    #define MAX_SIZE 100

    typedef struct Matrix {
        int size;
        int data[MAX_SIZE][MAX_SIZE];
    } Matrix;

    void printMatrix(Matrix* matrix) {
        for (int i = 0; i < matrix->size; i++) {
            for (int j = 0; j < matrix->size; j++) {
                printf("%d ", matrix->data[i][j]);
            }
            printf("\n");
        }
    }

    void addMatrix(Matrix* matrix1, Matrix* matrix2) {
        if (matrix1->size != matrix2->size) {
            printf("Error: Matrices must be of the same size.\n");
            return;
        }

        for (int i = 0; i < matrix1->size; i++) {
            for (int j = 0; j < matrix1->size; j++) {
                matrix1->data[i][j] += matrix2->data[i][j];
            }
        }
    }

    void multiplyMatrix(Matrix* matrix1, Matrix* matrix2) {
        if (matrix1->size != matrix2->size) {
            printf("Error: Matrices must be of the same size.\n");
            return;
        }

        for (int i = 0; i < matrix1->size; i++) {
            for (int j = 0; j < matrix1->size; j++) {
                matrix1->data[i][j] *= matrix2->data[i][j];
            }
        }
    }

    int main() {
        Matrix matrix1 = {
            .size = 3,
            .data = {
                {1, 2, 3},
                {4, 5, 6},
                {7, 8, 9}
            }
        };

        Matrix matrix2 = {
            .size = 3,
            .data = {
                {1, 2, 3},
                {4, 5, 6},
                {7, 8, 9}
            }
        };

        printf("Matrix 1:\n");
        printMatrix(&matrix1);

        printf("Matrix 2:\n");
        printMatrix(&matrix2);

        printf("Matrix 1 + Matrix 2:\n");
        addMatrix(&matrix1, &matrix2);
        printMatrix(&matrix1);

        printf("Matrix 1 * Matrix 2:\n");
        multiplyMatrix(&matrix1, &matrix2);
        printMatrix(&matrix1);

        return 0;
    }