//Falcon2-11B DATASET v1.0 Category: Socket programming ; Style: brave
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>

#define PORT 8080
#define BUFFER_SIZE 1024

int main() {
    int sockfd, portno, n;
    struct sockaddr_in serv_addr;
    char buffer[BUFFER_SIZE];

    // create socket
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) {
        perror("socket failed");
        exit(EXIT_FAILURE);
    }

    // assign port number
    portno = PORT;

    // fill server address structure
    bzero((char *) &serv_addr, sizeof(serv_addr));
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_addr.s_addr = htonl(INADDR_ANY);
    serv_addr.sin_port = htons(portno);

    // connect to server
    if (connect(sockfd, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0) {
        perror("connect failed");
        exit(EXIT_FAILURE);
    }

    printf("Connection Established!\n");

    // receive data from server
    n = recv(sockfd, buffer, BUFFER_SIZE, 0);
    if (n < 0) {
        perror("recv failed");
        exit(EXIT_FAILURE);
    }

    printf("Received Data: %s\n", buffer);

    // send data to server
    strcpy(buffer, "Hello, server!");
    n = send(sockfd, buffer, strlen(buffer), 0);
    if (n < 0) {
        perror("send failed");
        exit(EXIT_FAILURE);
    }

    printf("Data Sent: %s\n", buffer);

    // close socket
    close(sockfd);

    return 0;
}