//Falcon-180B DATASET v1.0 Category: Interprocess communication ; Style: Romeo and Juliet
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h>
#include <pthread.h>

#define MAX_SIZE 100
#define NUM_THREADS 2

char buffer[MAX_SIZE];
int buffer_index = 0;

pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;

void *producer(void *arg) {
    int i;
    for (i = 0; i < 10; i++) {
        pthread_mutex_lock(&mutex);

        if (buffer_index == MAX_SIZE) {
            printf("Buffer is full. Producer %d is waiting...\n", i);
            pthread_mutex_unlock(&mutex);
            sleep(1);
            continue;
        }

        sprintf(buffer + buffer_index, "Romeo: %d\n", i);
        buffer_index += strlen(buffer + buffer_index);

        printf("Producer %d has produced: %s", i, buffer);
        pthread_mutex_unlock(&mutex);
        sleep(1);
    }
    return NULL;
}

void *consumer(void *arg) {
    int i;
    for (i = 0; i < 10; i++) {
        pthread_mutex_lock(&mutex);

        if (buffer_index == 0) {
            printf("Buffer is empty. Consumer %d is waiting...\n", i);
            pthread_mutex_unlock(&mutex);
            sleep(1);
            continue;
        }

        printf("Consumer %d has consumed: %s", i, buffer);
        memset(buffer, '\0', MAX_SIZE);
        buffer_index = 0;

        pthread_mutex_unlock(&mutex);
        sleep(1);
    }
    return NULL;
}

int main() {
    pthread_t threads[NUM_THREADS];

    int i;
    for (i = 0; i < NUM_THREADS; i++) {
        pthread_create(&threads[i], NULL, (i % 2 == 0)? producer : consumer, NULL);
    }

    for (i = 0; i < NUM_THREADS; i++) {
        pthread_join(threads[i], NULL);
    }

    return 0;
}