//Falcon-180B DATASET v1.0 Category: Geometric algorithms ; Style: authentic
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Define structures for points and vectors
typedef struct {
    double x;
    double y;
} Point;

typedef struct {
    double x;
    double y;
} Vector;

// Define functions for geometric algorithms
double distance(Point p1, Point p2) {
    Vector v = {p2.x - p1.x, p2.y - p1.y};
    return sqrt(v.x * v.x + v.y * v.y);
}

double area(Point p1, Point p2, Point p3) {
    Vector v1 = {p2.x - p1.x, p2.y - p1.y};
    Vector v2 = {p3.x - p1.x, p3.y - p1.y};
    return 0.5 * fabs(v1.x * v2.y - v1.y * v2.x);
}

double perimeter(Point p1, Point p2, Point p3) {
    double d1 = distance(p1, p2);
    double d2 = distance(p2, p3);
    double d3 = distance(p3, p1);
    return d1 + d2 + d3;
}

int main() {
    // Define points
    Point p1 = {0, 0};
    Point p2 = {3, 4};
    Point p3 = {6, 0};

    // Calculate distances, areas, and perimeters
    double d12 = distance(p1, p2);
    double d23 = distance(p2, p3);
    double d31 = distance(p3, p1);
    double a123 = area(p1, p2, p3);
    double p123 = perimeter(p1, p2, p3);

    // Print results
    printf("Distance between p1 and p2: %.2f\n", d12);
    printf("Distance between p2 and p3: %.2f\n", d23);
    printf("Distance between p3 and p1: %.2f\n", d31);
    printf("Area of triangle p1p2p3: %.2f\n", a123);
    printf("Perimeter of triangle p1p2p3: %.2f\n", p123);

    return 0;
}