//Falcon-180B DATASET v1.0 Category: Traffic Light Controller ; Style: Donald Knuth
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define GREEN_LIGHT_DURATION 10
#define YELLOW_LIGHT_DURATION 3
#define RED_LIGHT_DURATION 20
#define TOTAL_CYCLE_DURATION (GREEN_LIGHT_DURATION + YELLOW_LIGHT_DURATION + RED_LIGHT_DURATION)

enum TrafficLightState {
    GREEN,
    YELLOW,
    RED
};

void changeTrafficLightState(enum TrafficLightState* state) {
    switch(*state) {
        case GREEN:
            *state = YELLOW;
            break;
        case YELLOW:
            *state = RED;
            break;
        case RED:
            *state = GREEN;
            break;
    }
}

void printTrafficLightState(enum TrafficLightState state) {
    switch(state) {
        case GREEN:
            printf("Green\n");
            break;
        case YELLOW:
            printf("Yellow\n");
            break;
        case RED:
            printf("Red\n");
            break;
    }
}

int main() {
    enum TrafficLightState trafficLightState = GREEN;
    int totalCycles = 0;

    while(1) {
        printTrafficLightState(trafficLightState);
        sleep(GREEN_LIGHT_DURATION);
        changeTrafficLightState(&trafficLightState);
        totalCycles++;

        if(totalCycles == 10) {
            printf("Simulation ended after %d cycles\n", totalCycles);
            return 0;
        }
    }

    return 0;
}