//Falcon-180B DATASET v1.0 Category: Terminal Based Game ; Style: minimalist
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Function prototypes
void game_init(void);
void game_loop(void);
void game_end(void);

// Global variables
int player_x, player_y;
int enemy_x, enemy_y;
int score;
char game_over;

int main(void) {
    srand(time(NULL));

    game_init();

    while (!game_over) {
        game_loop();
    }

    game_end();

    return 0;
}

void game_init(void) {
    player_x = rand() % 20;
    player_y = rand() % 10;
    enemy_x = rand() % 20;
    enemy_y = rand() % 10;
    score = 0;
    game_over = 0;
}

void game_loop(void) {
    system("clear");

    printf("Score: %d\n", score);
    printf("Player: %c\n", '@');
    printf("Enemy: %c\n", 'E');

    if (player_x == enemy_x && player_y == enemy_y) {
        game_over = 1;
    }

    if (game_over) {
        printf("Game Over!\n");
    } else {
        printf("Press any key to move...\n");
        getchar();

        int dx = 0;
        int dy = 0;

        if (player_x < enemy_x) {
            dx = 1;
        } else if (player_x > enemy_x) {
            dx = -1;
        }

        if (player_y < enemy_y) {
            dy = 1;
        } else if (player_y > enemy_y) {
            dy = -1;
        }

        player_x += dx;
        player_y += dy;

        if (player_x < 0 || player_x >= 20 || player_y < 0 || player_y >= 10) {
            game_over = 1;
        }
    }
}

void game_end(void) {
    printf("Thanks for playing!\n");
}