//LLAMA2-13B DATASET v1.0 Category: Compression algorithms ; Style: irregular
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAX_LEN 1024
#define DELTA 3

// Compression function
void compress(char *data, int len) {
  int i, j, k;
  char c;
  char prev = 0;
  char curr = 0;
  char next = 0;
  int count = 0;

  // Step 1: Find repeated characters
  for (i = 0; i < len; i++) {
    c = data[i];
    if (c == prev) {
      count++;
    } else {
      count = 1;
      prev = c;
    }
  }

  // Step 2: Replace repeated characters with delta
  for (i = 0; i < len; i++) {
    c = data[i];
    if (c == prev) {
      data[i] = (char)((int)c + DELTA);
    } else {
      prev = c;
    }
  }

  // Step 3: Compress remaining characters
  for (i = 0; i < len; i++) {
    c = data[i];
    if (c >= 'A' && c <= 'Z') {
      curr = (char)((int)c - 'A' + 'a');
      next = data[i + 1];
      if (next == ' ') {
        data[i] = curr + next;
      } else {
        data[i] = curr;
      }
    }
  }
}

// Decompression function
void decompress(char *data, int len) {
  int i, j, k;
  char c;
  char prev = 0;
  char curr = 0;
  char next = 0;
  int count = 0;

  // Step 1: Find delta-encoded characters
  for (i = 0; i < len; i++) {
    c = data[i];
    if (c >= 'a' && c <= 'z') {
      curr = (char)((int)c - 'a' + 'A');
      next = data[i + 1];
      if (next == ' ') {
        data[i] = curr + next;
      } else {
        data[i] = curr;
      }
    }
    count++;
  }

  // Step 2: Replace delta-encoded characters with original characters
  for (i = 0; i < len; i++) {
    c = data[i];
    if (c >= 'a' && c <= 'z') {
      data[i] = (char)((int)c - 'a' + 'A');
    }
  }

  // Step 3: Uncompress remaining characters
  for (i = 0; i < len; i++) {
    c = data[i];
    if (c == ' ') {
      data[i] = ' ';
    }
  }
}

int main() {
  char data[] = "Hello World!";
  int len = strlen(data);

  // Compress data
  compress(data, len);

  // Decompress data
  decompress(data, len);

  // Print original and compressed data
  printf("Original: %s\n", data);
  printf("Compressed: %s\n", data);

  return 0;
}