//Falcon-180B DATASET v1.0 Category: Database querying ; Style: modular
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>

static int callback(void *NotUsed, int argc, char **argv, char **azColName) {
    for (int i = 0; i < argc; i++) {
        printf("%s = %s\n", azColName[i], argv[i]? argv[i] : "NULL");
    }
    printf("\n");
    return 0;
}

void create_table(sqlite3 *db) {
    char *sql = "CREATE TABLE IF NOT EXISTS users("
        "id INTEGER PRIMARY KEY AUTOINCREMENT,"
        "name TEXT NOT NULL,"
        "age INTEGER NOT NULL);";
    char *errMsg = 0;

    if (sqlite3_exec(db, sql, 0, 0, &errMsg)) {
        fprintf(stderr, "Error creating table: %s\n", errMsg);
        sqlite3_free(errMsg);
    } else {
        printf("Table created successfully\n");
    }
}

void insert_data(sqlite3 *db) {
    char *sql = "INSERT INTO users(name, age) VALUES('John Doe', 30);";
    char *errMsg = 0;

    if (sqlite3_exec(db, sql, 0, 0, &errMsg)) {
        fprintf(stderr, "Error inserting data: %s\n", errMsg);
        sqlite3_free(errMsg);
    } else {
        printf("Data inserted successfully\n");
    }
}

void query_data(sqlite3 *db) {
    char *sql = "SELECT * FROM users;";
    char *errMsg = 0;

    if (sqlite3_exec(db, sql, callback, 0, &errMsg)) {
        fprintf(stderr, "Error querying data: %s\n", errMsg);
        sqlite3_free(errMsg);
    }
}

int main() {
    sqlite3 *db;
    int rc;

    rc = sqlite3_open("test.db", &db);

    if (rc) {
        fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
        return 1;
    }

    create_table(db);
    insert_data(db);
    query_data(db);

    sqlite3_close(db);
    return 0;
}