
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <unistd.h>

#define SHM_SIZE 1024  

int main() {
    
    int shmid = shmget(IPC_PRIVATE, SHM_SIZE, IPC_CREAT | 0666);
    if (shmid == -1) {
        perror("shmget");
        exit(1);
    }

    
    void *shmaddr = shmat(shmid, NULL, 0);
    if (shmaddr == (void *)-1) {
        perror("shmat");
        exit(1);
    }

    
    char *message = (char *)shmaddr;

    
    pid_t child1_pid = fork();
    if (child1_pid == -1) {
        perror("fork");
        exit(1);
    }

    if (child1_pid == 0) {  
        
        sprintf(message, "Hello from child process 1!");

        
        wait(NULL);

        
        shmdt(shmaddr);

        exit(0);
    }

    pid_t child2_pid = fork();
    if (child2_pid == -1) {
        perror("fork");
        exit(1);
    }

    if (child2_pid == 0) {  
        
        printf("Message from child process 1: %s\n", message);

        
        shmdt(shmaddr);

        exit(0);
    }

    
    waitpid(child1_pid, NULL, 0);
    waitpid(child2_pid, NULL, 0);

    
    shmdt(shmaddr);

    
    shmctl(shmid, IPC_RMID, NULL);

    return 0;
}