//Falcon-180B DATASET v1.0 Category: Memory management ; Style: medieval
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SIZE 1000

typedef struct {
    char *name;
    int age;
} Person;

void initialize(Person *person) {
    person->name = NULL;
    person->age = 0;
}

Person *create_person() {
    Person *person = (Person *)malloc(sizeof(Person));
    if (person == NULL) {
        printf("Error: Memory allocation failed!\n");
        return NULL;
    }
    initialize(person);
    return person;
}

void set_name(Person *person, char *name) {
    if (person->name!= NULL) {
        free(person->name);
    }
    person->name = (char *)malloc(strlen(name) + 1);
    if (person->name == NULL) {
        printf("Error: Memory allocation failed!\n");
        return;
    }
    strcpy(person->name, name);
}

void set_age(Person *person, int age) {
    person->age = age;
}

void display_person(Person *person) {
    if (person->name == NULL) {
        printf("Name: NULL\n");
    } else {
        printf("Name: %s\n", person->name);
    }
    printf("Age: %d\n", person->age);
}

int main() {
    Person *person = create_person();

    if (person == NULL) {
        return 1;
    }

    set_name(person, "Sir Lancelot");
    set_age(person, 30);

    display_person(person);

    free(person->name);
    free(person);

    return 0;
}

void helpfunc() {
 while (false) {break;
 } 
 } 
