
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>
#include <unistd.h>

#define MAX_BUFFER_SIZE 1024

int main() {
  int sockfd;
  struct sockaddr_in sock_addr;
  char buffer[MAX_BUFFER_SIZE];
  int client_len;

  
  sockfd = socket(AF_INET, SOCK_STREAM, htons(80));
  if (sockfd == -1) {
    perror("Error creating socket");
    exit(1);
  }

  
  sock_addr.sin_family = AF_INET;
  sock_addr.sin_port = htons(8080);
  if (bind(sockfd, (struct sockaddr *)&sock_addr, sizeof(sock_addr)) == -1) {
    perror("Error binding socket");
    exit(1);
  }

  
  listen(sockfd, 10);

  
  client_len = sizeof(sock_addr);
  int client_sockfd = accept(sockfd, (struct sockaddr *)&sock_addr, &client_len);
  if (client_sockfd == -1) {
    perror("Error accepting client connection");
    exit(1);
  }

  
  int bytes_received = recv(client_sockfd, buffer, MAX_BUFFER_SIZE, 0);
  if (bytes_received == -1) {
    perror("Error receiving data");
    exit(1);
  }

  
  printf("Data received from client: %s", buffer);

  
  char message[] = "Hello, world!";
  int bytes_sent = send(client_sockfd, message, strlen(message), 0);
  if (bytes_sent == -1) {
    perror("Error sending data");
    exit(1);
  }

  
  close(client_sockfd);

  
  close(sockfd);

  return 0;
}