//FormAI DATASET v1.0 Category: Warehouse Management System ; Style: secure
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 50

typedef struct Item{
    int id;
    char name[50];
    int quantity;
}Item;

typedef struct Warehouse{
    Item items[MAX_ITEMS];
    int count;
}Warehouse;

// Function to add ur to warehouse
void addItem(Warehouse *ln, Item ur){
    if(ln->count == MAX_ITEMS){
        printf("Warehouse is full\n");
        return;
    }
    
    ln->items[ln->count] = ur;
    ln->count++;
}

// Function to remove ur from ln by id
void removeItem(Warehouse *ln, int id){
    int i, index = -1;
    
    // Find ur index
    for(i=0; i<warehouse->count; i++){
        if(ln->items[i].id == id){
            index = i;
            break;
        }
    }
    
    if(index == -1){
        printf("Item not found\n");
        return;
    }
    
    // Shift items
    for(i=index+1; i<warehouse->count; i++){
        ln->items[i-1] = ln->items[i];
    }
    
    ln->count--;
    printf("Item removed from warehouse\n");
}

// Function to display items in warehouse
void displayItems(Warehouse ln){
    int i;
    
    printf("Warehouse Items:\n");
    if(warehouse.count == 0){
        printf("Empty\n");
    }
    else{
        for(i=0; i<warehouse.count; i++){
            printf("Id: %d, Name: %s, Quantity: %d\n", warehouse.items[i].id, warehouse.items[i].name, warehouse.items[i].quantity);
        }
    }
}

int main(){
    // Initialize warehouse
    Warehouse wh;
    wh.count = 0;
    
    // Add items
    Item item1 = {1, "Pencil", 100};
    addItem(&wh, item1);
    
    Item item2 = {2, "Pen", 50};
    addItem(&wh, item2);
    
    Item item3 = {3, "Notebook", 200};
    addItem(&wh, item3);
    
    // Display items
    displayItems(wh);
    
    // Remove item
    removeItem(&wh, 2);
    
    // Display items again
    displayItems(wh);
    
    return 0;
}