


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <netinet/in.h>
#include <unistd.h>

#define PORT 8080
#define MAX_BUFFER_SIZE 1024

int main(int argc, char *argv[]) {
    int sock, n;
    char buffer[MAX_BUFFER_SIZE];
    struct sockaddr_in server_addr, client_addr;
    socklen_t client_addr_len = sizeof(client_addr);

    
    sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0) {
        perror("socket");
        exit(1);
    }

    
    memset(&server_addr, 0, sizeof(server_addr));
    server_addr.sin_family = AF_INET;
    server_addr.sin_addr.s_addr = INADDR_ANY;
    server_addr.sin_port = htons(PORT);

    
    if (bind(sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
        perror("bind");
        exit(1);
    }

    
    if (listen(sock, 3) < 0) {
        perror("listen");
        exit(1);
    }

    
    printf("Waiting for incoming connection...\n");
    int client_sock = accept(sock, (struct sockaddr *)&client_addr, &client_addr_len);
    if (client_sock < 0) {
        perror("accept");
        exit(1);
    }
    printf("Connection accepted\n");

    
    n = recv(client_sock, buffer, MAX_BUFFER_SIZE, 0);
    if (n < 0) {
        perror("recv");
        exit(1);
    }
    printf("Received message: %s\n", buffer);

    
    n = send(client_sock, "Hello, client!", 13, 0);
    if (n < 0) {
        perror("send");
        exit(1);
    }
    printf("Message sent\n");

    
    close(client_sock);
    return 0;
}