

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <errno.h>

#define BUFFER_SIZE 1024

int main() {
  
  int sock = socket(AF_INET, SOCK_STREAM, 0);
  if (sock < 0) {
    perror("Socket creation failed");
    exit(1);
  }

  
  struct sockaddr_in server_addr;
  memset(&server_addr, 0, sizeof(server_addr));
  server_addr.sin_family = AF_INET;
  server_addr.sin_port = htons(80);
  server_addr.sin_addr.s_addr = inet_addr("127.0.0.1");

  
  if (connect(sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
    perror("Connect failed");
    exit(1);
  }

  
  char request[] = "GET / HTTP/1.1\r\nHost: localhost\r\n\r\n";
  if (send(sock, request, strlen(request), 0) < 0) {
    perror("Send failed");
    exit(1);
  }

  
  char buffer[BUFFER_SIZE];
  int bytes_received = recv(sock, buffer, BUFFER_SIZE, 0);
  if (bytes_received < 0) {
    perror("Receive failed");
    exit(1);
  }

  
  printf("Received HTTP response:\n%s\n", buffer);

  
  close(sock);

  return 0;
}