//MISTRAL-7B DATASET v1.0 Category: Dice Roller ; Style: high level of detail
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_SIDES 6
#define NUM_DICE 3

typedef struct DiceRoll {
    int sides;
    int roll[NUM_DICE];
} DiceRoll;

void generate_random_numbers(DiceRoll *dice_roll) {
    int i;

    for (i = 0; i < NUM_DICE; i++) {
        dice_roll->roll[i] = rand() % dice_roll->sides + 1;
    }
}

void print_roll(const DiceRoll *dice_roll) {
    int i;

    printf("Rolling %d dice with %d sides each:\n", NUM_DICE, dice_roll->sides);

    for (i = 0; i < NUM_DICE; i++) {
        printf("Dice %d rolled a %d\n", i + 1, dice_roll->roll[i]);
    }

    printf("\nTotal: %d\n", sum_array(dice_roll->roll, NUM_DICE));
}

int sum_array(const int *array, size_t size) {
    int sum = 0;
    size_t i;

    for (i = 0; i < size; i++) {
        sum += array[i];
    }

    return sum;
}

int main() {
    DiceRoll dice;
    dice.sides = NUM_SIDES;

    srand(time(NULL));

    printf("Starting a new game...\n");

    generate_random_numbers(&dice);
    print_roll(&dice);

    return 0;
}