//GEMINI-pro DATASET v1.0 Category: Greedy Algorithms ; Style: protected
#include <stdio.h>
#include <stdlib.h>

// Data structure to represent a job
typedef struct Job {
    int id;             // Job ID
    int deadline;       // Deadline for the job
    int profit;         // Profit earned by completing the job
} Job;

// Comparison function to sort jobs in decreasing order of profit
int compare(const void *a, const void *b) {
    Job *job1 = (Job *)a;
    Job *job2 = (Job *)b;
    return job2->profit - job1->profit;
}

// Function to schedule jobs greedily
void scheduleJobs(Job jobs[], int n) {
    // Sort the jobs in decreasing order of profit
    qsort(jobs, n, sizeof(Job), compare);

    // Create a vector to store the scheduled jobs
    int scheduled[n];
    for (int i = 0; i < n; i++) {
        scheduled[i] = -1;
    }

    // Iterate through the jobs in decreasing order of profit
    for (int i = 0; i < n; i++) {
        // Find the earliest available slot for the current job
        int slot = jobs[i].deadline - 1;
        while (slot >= 0 && scheduled[slot] != -1) {
            slot--;
        }

        // If a slot is found, schedule the job in that slot
        if (slot >= 0) {
            scheduled[slot] = jobs[i].id;
        }
    }

    // Print the scheduled jobs
    printf("Scheduled jobs:\n");
    for (int i = 0; i < n; i++) {
        if (scheduled[i] != -1) {
            printf("%d ", scheduled[i]);
        }
    }
    printf("\n");
}

// Driver program to test the scheduleJobs function
int main() {
    // Create an array of jobs
    Job jobs[] = {
        {1, 2, 100},
        {2, 1, 19},
        {3, 2, 27},
        {4, 1, 25},
        {5, 3, 15},
    };

    // Number of jobs
    int n = sizeof(jobs) / sizeof(Job);

    // Schedule the jobs greedily
    scheduleJobs(jobs, n);

    return 0;
}