//MISTRAL-7B DATASET v1.0 Category: Database simulation ; Style: Ada Lovelace
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define MAX_RECORDS 10
#define RECORD_SIZE 100

typedef struct {
    char name[50];
    int age;
    float height;
} Record;

Record database[MAX_RECORDS];
int currentRecord = 0;

void createRecord(const char* name, int age, float height) {
    if (currentRecord >= MAX_RECORDS) {
        printf("Database is full.\n");
        return;
    }

    strcpy(database[currentRecord].name, name);
    database[currentRecord].age = age;
    database[currentRecord].height = height;
    currentRecord++;
}

void readRecord(int index) {
    if (index >= 0 && index < currentRecord) {
        printf("Name: %s\n", database[index].name);
        printf("Age: %d\n", database[index].age);
        printf("Height: %.2f\n", database[index].height);
    } else {
        printf("Invalid index.\n");
    }
}

void updateRecord(int index, const char* newName, int newAge, float newHeight) {
    if (index >= 0 && index < currentRecord) {
        strcpy(database[index].name, newName);
        database[index].age = newAge;
        database[index].height = newHeight;
    } else {
        printf("Invalid index.\n");
    }
}

void deleteRecord(int index) {
    if (index >= 0 && index < currentRecord) {
        int i;
        for (i = index; i < currentRecord - 1; i++) {
            database[i] = database[i + 1];
        }
        currentRecord--;
    } else {
        printf("Invalid index.\n");
    }
}

int main() {
    createRecord("Alice", 25, 1.65);
    createRecord("Bob", 30, 1.75);
    readRecord(0);
    updateRecord(0, "Alice2", 26, 1.66);
    readRecord(0);
    deleteRecord(1);
    readRecord(1);

    return 0;
}