//GEMINI-pro DATASET v1.0 Category: Stock market tracker ; Style: systematic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Structure to store stock information
typedef struct Stock {
    char *name;
    float price;
    int volume;
} Stock;

// Array of stocks
Stock stocks[] = {
    {"Apple", 120.00, 1000},
    {"Microsoft", 90.00, 2000},
    {"Google", 150.00, 1500},
    {"Amazon", 200.00, 1000},
    {"Tesla", 300.00, 500}
};

// Number of stocks
#define NUM_STOCKS (sizeof(stocks) / sizeof(Stock))

// Function to print stock information
void printStock(Stock *stock) {
    printf("Name: %s\n", stock->name);
    printf("Price: %.2f\n", stock->price);
    printf("Volume: %d\n", stock->volume);
    printf("---------------------\n");
}

// Function to compare stocks by price
int compareStocksByPrice(const void *a, const void *b) {
    const Stock *stock1 = a;
    const Stock *stock2 = b;

    return stock1->price - stock2->price;
}

// Function to compare stocks by volume
int compareStocksByVolume(const void *a, const void *b) {
    const Stock *stock1 = a;
    const Stock *stock2 = b;

    return stock1->volume - stock2->volume;
}

// Function to get the most expensive stock
Stock *getMostExpensiveStock() {
    Stock *mostExpensiveStock = stocks;

    for (int i = 0; i < NUM_STOCKS; i++) {
        if (stocks[i].price > mostExpensiveStock->price) {
            mostExpensiveStock = &stocks[i];
        }
    }

    return mostExpensiveStock;
}

// Function to get the most traded stock
Stock *getMostTradedStock() {
    Stock *mostTradedStock = stocks;

    for (int i = 0; i < NUM_STOCKS; i++) {
        if (stocks[i].volume > mostTradedStock->volume) {
            mostTradedStock = &stocks[i];
        }
    }

    return mostTradedStock;
}

// Main function
int main() {
    // Print the original array of stocks
    printf("Original array of stocks:\n");
    for (int i = 0; i < NUM_STOCKS; i++) {
        printStock(&stocks[i]);
    }

    // Sort the array of stocks by price
    qsort(stocks, NUM_STOCKS, sizeof(Stock), compareStocksByPrice);

    // Print the sorted array of stocks by price
    printf("Array of stocks sorted by price:\n");
    for (int i = 0; i < NUM_STOCKS; i++) {
        printStock(&stocks[i]);
    }

    // Sort the array of stocks by volume
    qsort(stocks, NUM_STOCKS, sizeof(Stock), compareStocksByVolume);

    // Print the sorted array of stocks by volume
    printf("Array of stocks sorted by volume:\n");
    for (int i = 0; i < NUM_STOCKS; i++) {
        printStock(&stocks[i]);
    }

    // Get the most expensive stock
    Stock *mostExpensiveStock = getMostExpensiveStock();

    // Print the most expensive stock
    printf("Most expensive stock:\n");
    printStock(mostExpensiveStock);

    // Get the most traded stock
    Stock *mostTradedStock = getMostTradedStock();

    // Print the most traded stock
    printf("Most traded stock:\n");
    printStock(mostTradedStock);

    return 0;
}