
#include <stdio.h>
#include <stdlib.h>


typedef struct {
    char name[50];
    int age;
    float grade;
} Student;


int compare_age(const void *a, const void *b) {
    const Student *student_a = a;
    const Student *student_b = b;

    if (student_a->age < student_b->age) {
        return -1;
    } else if (student_a->age > student_b->age) {
        return 1;
    } else {
        return 0;
    }
}


int compare_grade(const void *a, const void *b) {
    const Student *student_a = a;
    const Student *student_b = b;

    if (student_a->grade < student_b->grade) {
        return -1;
    } else if (student_a->grade > student_b->grade) {
        return 1;
    } else {
        return 0;
    }
}


void print_student(const void *student) {
    const Student *s = student;

    printf("Name: %s\n", s->name);
    printf("Age: %d\n", s->age);
    printf("Grade: %.2f\n\n", s->grade);
}


int main() {
    
    Student students[] = {
        {"Alice", 18, 85.5},
        {"Bob", 19, 90.0},
        {"Charlie", 20, 78.0},
        {"David", 21, 95.5},
        {"Eve", 22, 88.0}
    };

    
    qsort(students, 5, sizeof(Student), compare_age);

    
    printf("Sorted by age:\n");
    for (int i = 0; i < 5; i++) {
        print_student(&students[i]);
    }

    
    qsort(students, 5, sizeof(Student), compare_grade);

    
    printf("\nSorted by grade:\n");
    for (int i = 0; i < 5; i++) {
        print_student(&students[i]);
    }

    return 0;
}