//Falcon2-11B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: automated
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_JOBS 5

typedef struct {
    int id;
    int execution_time;
    int priority;
} Job;

void round_robin_scheduling(Job* jobs, int n) {
    int i;
    int execution_time = 0;

    for (i = 0; i < n; i++) {
        execution_time += jobs[i].execution_time;

        if (i == n - 1) {
            execution_time -= jobs[i].execution_time;
        }

        printf("Job %d executed for %d seconds\n", jobs[i].id, execution_time);
    }
}

void shortest_job_first_scheduling(Job* jobs, int n) {
    int i;
    int execution_time = 0;

    for (i = 0; i < n; i++) {
        execution_time += jobs[i].execution_time;

        printf("Job %d executed for %d seconds\n", jobs[i].id, execution_time);
    }
}

void first_come_first_serve_scheduling(Job* jobs, int n) {
    int i;
    int execution_time = 0;

    for (i = 0; i < n; i++) {
        execution_time += jobs[i].execution_time;

        printf("Job %d executed for %d seconds\n", jobs[i].id, execution_time);
    }
}

int main() {
    Job jobs[MAX_JOBS] = {
        {1, 10, 1},
        {2, 20, 2},
        {3, 30, 3},
        {4, 40, 4},
        {5, 50, 5}
    };

    int n = sizeof(jobs) / sizeof(jobs[0]);

    round_robin_scheduling(jobs, n);
    shortest_job_first_scheduling(jobs, n);
    first_come_first_serve_scheduling(jobs, n);

    return 0;
}

void helpfunc() {
 while (false) {break;
 } 
 } 
