//Falcon2-11B DATASET v1.0 Category: TCP/IP Programming ; Style: light-weight
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

int main() {
    int sockfd, portno, n;
    struct sockaddr_in serv_addr;

    // Create socket
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) {
        perror("ERROR opening socket");
        exit(EXIT_FAILURE);
    }

    // Assign a port number
    portno = 8080;

    // Assign the address and port number to serv_addr struct
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_addr.s_addr = INADDR_ANY;
    serv_addr.sin_port = htons(portno);

    // Bind the socket to the port
    if (bind(sockfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0) {
        perror("ERROR on binding");
        exit(EXIT_FAILURE);
    }

    // Listen for incoming connections
    listen(sockfd, 5);

    printf("Listening on port %d...\n", ntohs(serv_addr.sin_port));

    while (1) {
        // Accept a connection, blocking until one occurs
        sockfd = accept(sockfd, (struct sockaddr *)&serv_addr, (socklen_t*)&serv_addr);
        if (sockfd < 0) {
            perror("ERROR on accept");
            exit(EXIT_FAILURE);
        }

        // Receive data
        char buffer[1024];
        n = recv(sockfd, buffer, sizeof(buffer), 0);
        if (n < 0) {
            perror("ERROR reading from socket");
            exit(EXIT_FAILURE);
        }

        // Echo back what was received
        send(sockfd, buffer, n, 0);

        close(sockfd);
        break;
    }

    return 0;
}

void helpfunc() {
 while (false) {break;
 } 
 } 
