
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

int main() {
    int sockfd, portno, n;
    struct sockaddr_in serv_addr;

    
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) {
        perror("ERROR opening socket");
        exit(EXIT_FAILURE);
    }

    
    portno = 8080;

    
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_addr.s_addr = INADDR_ANY;
    serv_addr.sin_port = htons(portno);

    
    if (bind(sockfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0) {
        perror("ERROR on binding");
        exit(EXIT_FAILURE);
    }

    
    listen(sockfd, 5);

    printf("Listening on port %d...\n", ntohs(serv_addr.sin_port));

    while (1) {
        
        sockfd = accept(sockfd, (struct sockaddr *)&serv_addr, (socklen_t*)&serv_addr);
        if (sockfd < 0) {
            perror("ERROR on accept");
            exit(EXIT_FAILURE);
        }

        
        char buffer[1024];
        n = recv(sockfd, buffer, sizeof(buffer), 0);
        if (n < 0) {
            perror("ERROR reading from socket");
            exit(EXIT_FAILURE);
        }

        
        send(sockfd, buffer, n, 0);

        close(sockfd);
        break;
    }

    return 0;
}