
#include <stdlib.h>
#include <stdio.h>


#define ARRAY_SIZE(a) (sizeof(a) / sizeof(a[0]))


int find_min(int arr[], int n) {
  int min = arr[0];
  for (int i = 1; i < n; i++) {
    if (arr[i] < min) {
      min = arr[i];
    }
  }
  return min;
}


int find_max(int arr[], int n) {
  int max = arr[0];
  for (int i = 1; i < n; i++) {
    if (arr[i] > max) {
      max = arr[i];
    }
  }
  return max;
}


double find_avg(int arr[], int n) {
  double sum = 0;
  for (int i = 0; i < n; i++) {
    sum += arr[i];
  }
  return sum / n;
}


void sort_ascending(int arr[], int n) {
  for (int i = 0; i < n - 1; i++) {
    for (int j = i + 1; j < n; j++) {
      if (arr[i] > arr[j]) {
        int temp = arr[i];
        arr[i] = arr[j];
        arr[j] = temp;
      }
    }
  }
}


void sort_descending(int arr[], int n) {
  for (int i = 0; i < n - 1; i++) {
    for (int j = i + 1; j < n; j++) {
      if (arr[i] < arr[j]) {
        int temp = arr[i];
        arr[i] = arr[j];
        arr[j] = temp;
      }
    }
  }
}


void print_array(int arr[], int n) {
  for (int i = 0; i < n; i++) {
    printf("%d ", arr[i]);
  }
  printf("\n");
}

int main() {
  
  int arr[] = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10};

  
  int n = ARRAY_SIZE(arr);

  
  int min = find_min(arr, n);

  
  int max = find_max(arr, n);

  
  double avg = find_avg(arr, n);

  
  sort_ascending(arr, n);

  
  sort_descending(arr, n);

  
  printf("Original array: ");
  print_array(arr, n);

  
  printf("Minimum element: %d\n", min);

  
  printf("Maximum element: %d\n", max);

  
  printf("Average: %.2f\n", avg);

  
  printf("Array sorted in ascending order: ");
  print_array(arr, n);

  
  printf("Array sorted in descending order: ");
  print_array(arr, n);

  return 0;
}