
#include <stdio.h>


struct user_info{
    char name[20];
    int age;
    char gender[10];
    float weight;
    float height;
};


float calculate_bmi(float weight, float height);
void display_bmi(float bmi);
void log_data(struct user_info user, float bmi);

int main(){
    
    struct user_info user = {"John", 25, "Male", 80, 1.8};

    
    float bmi = calculate_bmi(user.weight, user.height);

    
    display_bmi(bmi);

    
    log_data(user, bmi);

    return 0;
}


float calculate_bmi(float weight, float height){
    return weight / (height * height);
}


void display_bmi(float bmi){
    printf("Your BMI is: %.2f\n", bmi);
    if(bmi < 18.5){
        printf("You are underweight.\n");
    } else if(bmi >= 18.5 && bmi < 25){
        printf("You are normal weight.\n");
    } else if(bmi >= 25 && bmi < 30){
        printf("You are overweight.\n");
    } else{
        printf("You are obese.\n");
    }
}


void log_data(struct user_info user, float bmi){
    
    FILE *log_file = fopen("user_log.txt", "a");

    
    fprintf(log_file, "Name: %s, Age: %d, Gender: %s, Weight: %.2f kg, Height: %.2f m, BMI: %.2f\n", user.name, user.age, user.gender, user.weight, user.height, bmi);

    
    fclose(log_file);
}