//FormAI DATASET v1.0 Category: Building a POP3 Client ; Style: scalable
#include <stdio.h>
#include <netdb.h>
#include <unistd.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>

#define PORT 110 //POP3 default port
#define BUFFER_SIZE 1024

//function declaration
void recvMessageAndPrint(int dd);

//main function
int main(int argc, char const *argv[]) {
    //variables declaration
    int dd;
    struct sockaddr_in servaddr;
    char buffer[BUFFER_SIZE];

    //creating a socket
    dd = socket(AF_INET, SOCK_STREAM, 0);
    if (dd < 0) {
        perror("Socket creation error!");
        return -1;
    }

    //resetting the buffer
    memset(&servaddr,0,sizeof(servaddr)); 

    //filling up the socket address structure
    servaddr.sin_family = AF_INET;
    servaddr.sin_port = htons(PORT);
    servaddr.sin_addr.s_addr = inet_addr("127.0.0.1");

    //connecting the client socket to server socket
    if (connect(dd, (struct sockaddr *)&servaddr, sizeof(servaddr)) != 0) {
        perror("Failed to connect with server!");
        close(dd);
        return -1;
    }

    //receiving the server greeting message
    recvMessageAndPrint(dd);

    //sending the user credentials
    strcpy(buffer, "USER exampleuser\r\n");
    send(dd, buffer, strlen(buffer), 0);
    recvMessageAndPrint(dd);

    //sending the user password
    strcpy(buffer, "PASS examplepassword\r\n");
    send(dd, buffer, strlen(buffer), 0);
    recvMessageAndPrint(dd);

    //closing the connection
    strcpy(buffer, "QUIT\r\n");
    send(dd, buffer, strlen(buffer), 0);
    recvMessageAndPrint(dd);
    close(dd);

    return 0;
}

//function definition to receive message from server and print it
void recvMessageAndPrint(int dd) {
    char buffer[BUFFER_SIZE];
    memset(buffer, 0, sizeof(buffer));
    recv(dd, buffer, BUFFER_SIZE, 0);
    printf("%s", buffer);
}