
#include <stdio.h>
#include <netdb.h>
#include <unistd.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>

#define PORT 110 
#define BUFFER_SIZE 1024


void recvMessageAndPrint(int sockfd);


int main(int argc, char const *argv[]) {
    
    int sockfd;
    struct sockaddr_in servaddr;
    char buffer[BUFFER_SIZE];

    
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) {
        perror("Socket creation error!");
        return -1;
    }

    
    memset(&servaddr,0,sizeof(servaddr)); 

    
    servaddr.sin_family = AF_INET;
    servaddr.sin_port = htons(PORT);
    servaddr.sin_addr.s_addr = inet_addr("127.0.0.1");

    
    if (connect(sockfd, (struct sockaddr *)&servaddr, sizeof(servaddr)) != 0) {
        perror("Failed to connect with server!");
        close(sockfd);
        return -1;
    }

    
    recvMessageAndPrint(sockfd);

    
    strcpy(buffer, "USER exampleuser\r\n");
    send(sockfd, buffer, strlen(buffer), 0);
    recvMessageAndPrint(sockfd);

    
    strcpy(buffer, "PASS examplepassword\r\n");
    send(sockfd, buffer, strlen(buffer), 0);
    recvMessageAndPrint(sockfd);

    
    strcpy(buffer, "QUIT\r\n");
    send(sockfd, buffer, strlen(buffer), 0);
    recvMessageAndPrint(sockfd);
    close(sockfd);

    return 0;
}


void recvMessageAndPrint(int sockfd) {
    char buffer[BUFFER_SIZE];
    memset(buffer, 0, sizeof(buffer));
    recv(sockfd, buffer, BUFFER_SIZE, 0);
    printf("%s", buffer);
}