


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ENTRIES 100
#define MAX_KEY_SIZE 100
#define MAX_DATA_SIZE 100

typedef struct {
    char key[MAX_KEY_SIZE];
    char data[MAX_DATA_SIZE];
} Entry;

void add_entry(Entry* entries, int* num_entries, char* key, char* data) {
    if (*num_entries < MAX_ENTRIES) {
        Entry* new_entry = &entries[*num_entries];
        strcpy(new_entry->key, key);
        strcpy(new_entry->data, data);
        *num_entries += 1;
    } else {
        printf("Error: maximum number of entries reached.\n");
    }
}

void search_entry(Entry* entries, int num_entries, char* key) {
    for (int i = 0; i < num_entries; i++) {
        if (strcmp(entries[i].key, key) == 0) {
            printf("Found entry: %s\n", entries[i].data);
            return;
        }
    }
    printf("Entry not found.\n");
}

void print_entries(Entry* entries, int num_entries) {
    for (int i = 0; i < num_entries; i++) {
        printf("Key: %s, Data: %s\n", entries[i].key, entries[i].data);
    }
}

int main() {
    Entry entries[MAX_ENTRIES];
    int num_entries = 0;

    add_entry(entries, &num_entries, "key1", "data1");
    add_entry(entries, &num_entries, "key2", "data2");
    add_entry(entries, &num_entries, "key3", "data3");

    search_entry(entries, num_entries, "key1");
    search_entry(entries, num_entries, "key4");

    print_entries(entries, num_entries);

    return 0;
}