//Gemma-7B DATASET v1.0 Category: URL Sanitizer ; Style: real-life
#include <stdio.h>
#include <string.h>
#include <ctype.h>

#define MAX_URL_LENGTH 256

void sanitize_url(char *url) {
  char *p = url;
  char *start = url;
  int length = 0;

  // Remove leading and trailing spaces
  while (*p && isspace(*p)) {
    p++;
  }

  // Convert remaining spaces to plus signs
  while (*p) {
    if (isspace(*p)) {
      *p = '+';
    }
    p++;
  }

  // Normalize case
  start = url;
  while (*start) {
    *start = tolower(*start);
    start++;
  }

  // Remove invalid characters
  p = url;
  while (*p) {
    if (!isalnum(*p) && *p != '+' && *p != '-' && *p != '.' && *p != '_') {
      *p = '\0';
    }
    p++;
  }

  // Trim trailing spaces
  while (*url && isspace(*url)) {
    *url = '\0';
  }

  // Copy sanitized URL to original buffer
  strcpy(url, start);
}

int main() {
  char url[MAX_URL_LENGTH] = "This is an example URL with spaces, special characters, and uppercase letters.";
  sanitize_url(url);

  printf("Sanitized URL: %s\n", url);

  return 0;
}