//GPT-4o-mini DATASET v1.0 Category: Matrix operations ; Style: mind-bending
#include <stdio.h>
#include <stdlib.h>

#define SIZE 4

// Function prototypes
void fillMatrix(int matrix[SIZE][SIZE]);
void printMatrix(int matrix[SIZE][SIZE]);
void transposeMatrix(int matrix[SIZE][SIZE], int transposed[SIZE][SIZE]);
void multiplyMatrices(int matrixA[SIZE][SIZE], int matrixB[SIZE][SIZE], int product[SIZE][SIZE]);
void addMatrices(int matrixA[SIZE][SIZE], int matrixB[SIZE][SIZE], int result[SIZE][SIZE]);

int main() {
    int matrixA[SIZE][SIZE], matrixB[SIZE][SIZE], result[SIZE][SIZE];
    int transposedA[SIZE][SIZE], transposedB[SIZE][SIZE];
    
    printf("Filling the whimsical Matrix A:\n");
    fillMatrix(matrixA);
    printMatrix(matrixA);
    
    printf("\nFilling the marvelous Matrix B:\n");
    fillMatrix(matrixB);
    printMatrix(matrixB);
    
    printf("\nTransposing Matrix A:\n");
    transposeMatrix(matrixA, transposedA);
    printMatrix(transposedA);
    
    printf("\nTransposing Matrix B:\n");
    transposeMatrix(matrixB, transposedB);
    printMatrix(transposedB);
    
    printf("\nAdding Matrix A and Matrix B:\n");
    addMatrices(matrixA, matrixB, result);
    printMatrix(result);
    
    printf("\nMultiplying Matrix A and Matrix B:\n");
    multiplyMatrices(matrixA, matrixB, result);
    printMatrix(result);
    
    return 0;
}

void fillMatrix(int matrix[SIZE][SIZE]) {
    for (int i = 0; i < SIZE; i++) {
        for (int j = 0; j < SIZE; j++) {
            matrix[i][j] = rand() % 10; // Filling with random numbers 0 to 9
        }
    }
}

void printMatrix(int matrix[SIZE][SIZE]) {
    for (int i = 0; i < SIZE; i++) {
        for (int j = 0; j < SIZE; j++) {
            printf("%2d ", matrix[i][j]);
        }
        printf("\n");
    }
    printf("\n");
}

void transposeMatrix(int matrix[SIZE][SIZE], int transposed[SIZE][SIZE]) {
    for (int i = 0; i < SIZE; i++) {
        for (int j = 0; j < SIZE; j++) {
            transposed[j][i] = matrix[i][j];
        }
    }
}

void addMatrices(int matrixA[SIZE][SIZE], int matrixB[SIZE][SIZE], int result[SIZE][SIZE]) {
    for (int i = 0; i < SIZE; i++) {
        for (int j = 0; j < SIZE; j++) {
            result[i][j] = matrixA[i][j] + matrixB[i][j];
        }
    }
}

void multiplyMatrices(int matrixA[SIZE][SIZE], int matrixB[SIZE][SIZE], int product[SIZE][SIZE]) {
    for (int i = 0; i < SIZE; i++) {
        for (int j = 0; j < SIZE; j++) {
            product[i][j] = 0; // Reset product matrix for each position
            for (int k = 0; k < SIZE; k++) {
                product[i][j] += matrixA[i][k] * matrixB[k][j];
            }
        }
    }
}