//GEMINI-pro DATASET v1.0 Category: Weather simulation ; Style: complete
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the weather types
#define SUNNY 0
#define CLOUDY 1
#define RAINING 2
#define SNOWING 3

// Define the temperature range
#define MIN_TEMP -20
#define MAX_TEMP 40

// Define the probability of each weather type
#define SUNNY_PROB 0.4
#define CLOUDY_PROB 0.3
#define RAINING_PROB 0.2
#define SNOWING_PROB 0.1

// Get a random number between 0 and 1
double get_random_number() {
  return (double)rand() / (double)RAND_MAX;
}

// Get a random weather type
int get_random_weather_type() {
  double r = get_random_number();

  if (r < SUNNY_PROB) {
    return SUNNY;
  } else if (r < SUNNY_PROB + CLOUDY_PROB) {
    return CLOUDY;
  } else if (r < SUNNY_PROB + CLOUDY_PROB + RAINING_PROB) {
    return RAINING;
  } else {
    return SNOWING;
  }
}

// Get a random temperature
int get_random_temperature() {
  return MIN_TEMP + (int)((MAX_TEMP - MIN_TEMP) * get_random_number());
}

// Print the weather report
void print_weather_report(int weather_type, int temperature) {
  switch (weather_type) {
    case SUNNY:
      printf("The weather is sunny and ");
      break;
    case CLOUDY:
      printf("The weather is cloudy and ");
      break;
    case RAINING:
      printf("The weather is raining and ");
      break;
    case SNOWING:
      printf("The weather is snowing and ");
      break;
  }

  printf("the temperature is %d degrees Celsius.\n", temperature);
}

// Main function
int main() {
  // Initialize the random number generator
  srand(time(NULL));

  // Get a random weather type
  int weather_type = get_random_weather_type();

  // Get a random temperature
  int temperature = get_random_temperature();

  // Print the weather report
  print_weather_report(weather_type, temperature);

  return 0;
}