//MISTRAL-7B DATASET v1.0 Category: Sentiment analysis tool ; Style: surprised
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

#define WORDS_SIZE 100
#define DICTIONARY_SIZE 50

typedef struct Word {
    char word[WORDS_SIZE];
    int score;
} Word;

Word dictionary[DICTIONARY_SIZE] = {
    {"amazing", 5},
    {"astonishing", 7},
    {"awesome", 6},
    {"brilliant", 8},
    {"fantastic", 9},
    {"incredible", 10},
    {"marvelous", 11},
    {"outstanding", 12},
    {"phenomenal", 13},
    {"stunning", 14},
    {"terrific", 15},
    {"wonderful", 16}
};

int get_word_score(char *word) {
    int i;
    for (i = 0; i < DICTIONARY_SIZE; i++) {
        if (strcmp(word, dictionary[i].word) == 0) {
            return dictionary[i].score;
        }
    }
    return 0;
}

int main() {
    char input[1000];
    int total_score = 0;
    int words_count = 0;

    printf("Welcome to the Sentiment Catcher!\n");
    printf("Type your text below and press enter.\n");
    fgets(input, sizeof(input), stdin);

    char *token = strtok(input, " .,?!:;");
    while (token != NULL) {
        if (strlen(token) > WORDS_SIZE) {
            printf("Warning: word too long! Word size limit is %d.\n", WORDS_SIZE);
            token = strtok(NULL, " .,?!:;");
            continue;
        }

        // Convert to lowercase
        for (int i = 0; i < strlen(token); i++) {
            token[i] = tolower(token[i]);
        }

        int word_score = get_word_score(token);
        if (word_score > 0) {
            total_score += word_score;
            words_count++;
            printf("Found positive word: %s\n", token);
        }

        token = strtok(NULL, " .,?!:;");
    }

    double average_score = (double) total_score / words_count;

    if (average_score > 7) {
        printf("\nSurprise! Your text is more positive than expected!\n");
        printf("Average score: %.2f\n", average_score);
    } else {
        printf("\nYour text seems to be neutral or negative.\n");
        printf("Average score: %.2f\n", average_score);
    }

    return 0;
}