//Falcon2-11B DATASET v1.0 Category: Memory Game ; Style: Donald Knuth
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <time.h>
#include <unistd.h>

#define NUM_CARDS 20
#define SHUFFLE_NUM 7

typedef struct {
    int num;
    char symbol;
} card_t;

typedef struct {
    int front;
    int back;
    int exposed;
} game_state_t;

void shuffle_cards(card_t* cards, int num) {
    for (int i = 0; i < num; i++) {
        int r = rand() % (i + 1);
        card_t temp = cards[i];
        cards[i] = cards[r];
        cards[r] = temp;
    }
}

void print_cards(card_t* cards, int num) {
    for (int i = 0; i < num; i++) {
        printf("%d - %c\n", cards[i].num, cards[i].symbol);
    }
}

int main() {
    srand(time(NULL));

    card_t cards[NUM_CARDS];
    for (int i = 0; i < NUM_CARDS; i++) {
        cards[i].num = i + 1;
        cards[i].symbol = 'a' + (i % 26);
    }

    game_state_t state = {.front = -1,.back = -1,.exposed = -1};

    while (state.front!= state.back) {
        shuffle_cards(cards, NUM_CARDS);

        print_cards(cards, NUM_CARDS);

        printf("\n");

        printf("Turn %d: ", state.exposed + 1);

        if (state.front!= -1) {
            printf("%d\n", cards[state.front].num);
        } else {
            printf("No cards left to turn over.\n");
        }

        printf("Turn %d: ", state.exposed + 2);

        if (state.front!= -1 && state.front!= state.back) {
            printf("%d\n", cards[state.front].num);
            state.exposed++;
        } else if (state.front == state.back) {
            printf("Congratulations! You won!\n");
            break;
        } else {
            printf("No cards left to turn over.\n");
        }
    }

    printf("Final state: ");
    if (state.front == state.back) {
        printf("You won!\n");
    } else {
        printf("You lost.\n");
    }

    return 0;
}