//GEMINI-pro DATASET v1.0 Category: Text-Based Adventure Game ; Style: minimalist
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define ROOMS 5
#define ITEMS 3
#define MAX_ITEM_SIZE 10

typedef struct {
    char *name;
    char *desc;
    int n_exits;
    int exits[4];
    int *items;
    int n_items;
} Room;

typedef struct {
    char *name;
    char *desc;
} Item;

Room rooms[ROOMS] = {
    {
        .name = "Living Room",
        .desc = "This is a cozy living room with a fireplace and a couch.",
        .n_exits = 2,
        .exits = {1, 2},
        .items = NULL,
        .n_items = 0
    },
    {
        .name = "Kitchen",
        .desc = "This is a small kitchen with a stove, a sink, and a refrigerator.",
        .n_exits = 2,
        .exits = {0, 3},
        .items = NULL,
        .n_items = 0
    },
    {
        .name = "Bedroom",
        .desc = "This is a small bedroom with a bed, a dresser, and a nightstand.",
        .n_exits = 1,
        .exits = {0},
        .items = NULL,
        .n_items = 0
    },
    {
        .name = "Bathroom",
        .desc = "This is a small bathroom with a toilet, a sink, and a bathtub.",
        .n_exits = 1,
        .exits = {1},
        .items = NULL,
        .n_items = 0
    },
    {
        .name = "Outside",
        .desc = "This is a small backyard with a patio and a garden.",
        .n_exits = 1,
        .exits = {1},
        .items = NULL,
        .n_items = 0
    }
};

Item items[ITEMS] = {
    {
        .name = "Key",
        .desc = "This is a small key that unlocks the door to the backyard."
    },
    {
        .name = "Sword",
        .desc = "This is a small sword that can be used to fight enemies."
    },
    {
        .name = "Potion",
        .desc = "This is a potion that can be used to heal the player."
    }
};

int player_room = 0;
int player_inventory[ITEMS] = {0};

void print_room(Room *room) {
    printf("%s\n", room->name);
    printf("%s\n", room->desc);
    if (room->n_items > 0) {
        printf("Items:\n");
        for (int i = 0; i < room->n_items; i++) {
            printf("  - %s\n", items[room->items[i]].name);
        }
    }
    if (room->n_exits > 0) {
        printf("Exits:\n");
        for (int i = 0; i < room->n_exits; i++) {
            printf("  - %s\n", rooms[room->exits[i]].name);
        }
    }
}

void print_inventory() {
    printf("Inventory:\n");
    for (int i = 0; i < ITEMS; i++) {
        if (player_inventory[i] > 0) {
            printf("  - %s (%d)\n", items[i].name, player_inventory[i]);
        }
    }
}

int main() {
    while (1) {
        Room *room = &rooms[player_room];

        print_room(room);

        char input[100];
        printf("> ");
        fgets(input, sizeof(input), stdin);

        char *command = strtok(input, " ");
        char *arg = strtok(NULL, " ");

        if (strcmp(command, "go") == 0) {
            int exit = atoi(arg);
            if (exit >= 0 && exit < room->n_exits) {
                player_room = room->exits[exit];
            } else {
                printf("Invalid exit.\n");
            }
        } else if (strcmp(command, "take") == 0) {
            int item = -1;
            for (int i = 0; i < room->n_items; i++) {
                if (strcmp(arg, items[room->items[i]].name) == 0) {
                    item = room->items[i];
                    break;
                }
            }
            if (item != -1) {
                player_inventory[item]++;
                room->n_items--;
                room->items = realloc(room->items, room->n_items * sizeof(int));
            } else {
                printf("Invalid item.\n");
            }
        } else if (strcmp(command, "drop") == 0) {
            int item = -1;
            for (int i = 0; i < ITEMS; i++) {
                if (strcmp(arg, items[i].name) == 0) {
                    item = i;
                    break;
                }
            }
            if (item != -1) {
                player_inventory[item]--;
                room->n_items++;
                room->items = realloc(room->items, room->n_items * sizeof(int));
                room->items[room->n_items - 1] = item;
            } else {
                printf("Invalid item.\n");
            }
        } else if (strcmp(command, "inv") == 0) {
            print_inventory();
        } else if (strcmp(command, "quit") == 0) {
            return 0;
        } else {
            printf("Invalid command.\n");
        }
    }

    return 0;
}