//GPT-4o-mini DATASET v1.0 Category: Threading Library Implementation ; Style: Sherlock Holmes
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <unistd.h>
#include <string.h>

#define NUM_THREADS 4

// Structure to hold data for each thread
typedef struct {
    int thread_id;
    const char *role;
} ThreadData;

// Function declarations
void *investigateClue(void *threadarg);
void *interrogateWitness(void *threadarg);
void *searchCrimeScene(void *threadarg);
void *analyzeEvidence(void *threadarg);

// Thread data
ThreadData thread_data[NUM_THREADS];

// Array to hold thread ids
pthread_t threads[NUM_THREADS];

// Main function
int main() {
    printf("Sherlock Holmes: The Case of the Missing Heirloom\n\n");
    
    // Initialize thread data and create threads
    thread_data[0].thread_id = 0;
    thread_data[0].role = "Investigator - Sherlock Holmes";

    thread_data[1].thread_id = 1;
    thread_data[1].role = "Inspector - Lestrade";

    thread_data[2].thread_id = 2;
    thread_data[2].role = "Witness - Mary";

    thread_data[3].thread_id = 3;
    thread_data[3].role = "Forensic Expert - Watson";

    // Create threads for different investigation tasks
    pthread_create(&threads[0], NULL, investigateClue, (void *)&thread_data[0]);
    pthread_create(&threads[1], NULL, interrogateWitness, (void *)&thread_data[1]);
    pthread_create(&threads[2], NULL, searchCrimeScene, (void *)&thread_data[2]);
    pthread_create(&threads[3], NULL, analyzeEvidence, (void *)&thread_data[3]);

    // Wait for all threads to complete
    for(int i = 0; i < NUM_THREADS; i++) {
        pthread_join(threads[i], NULL);
    }

    printf("\nThe case is solved! We have the perpetrator!\n");
    return 0;
}

// Function to simulate investigating a clue
void *investigateClue(void *threadarg) {
    ThreadData *data;
    data = (ThreadData *) threadarg;

    printf("%s is investigating the first clue...\n", data->role);
    sleep(2);
    printf("%s discovered a hidden note in the library!\n", data->role);
    pthread_exit(NULL);
}

// Function to simulate interrogating a witness
void *interrogateWitness(void *threadarg) {
    ThreadData *data;
    data = (ThreadData *) threadarg;

    printf("%s is interrogating the witness...\n", data->role);
    sleep(3);
    printf("%s has gathered vital information about the suspect!\n", data->role);
    pthread_exit(NULL);
}

// Function to simulate searching the crime scene
void *searchCrimeScene(void *threadarg) {
    ThreadData *data;
    data = (ThreadData *) threadarg;

    printf("%s is searching the crime scene...\n", data->role);
    sleep(4);
    printf("%s found traces of the suspect's belongings!\n", data->role);
    pthread_exit(NULL);
}

// Function to simulate analyzing evidence
void *analyzeEvidence(void *threadarg) {
    ThreadData *data;
    data = (ThreadData *) threadarg;

    printf("%s is analyzing the evidence...\n", data->role);
    sleep(5);
    printf("%s confirmed that the fingerprints match the suspect!\n", data->role);
    pthread_exit(NULL);
}