//GEMINI-pro DATASET v1.0 Category: Greedy Algorithms ; Style: surprised
/*
 * Behold! A Greedy Algorithm cometh!
 *
 * What mysteries doth it hold?
 * What treasures shall it bestow upon us?
 *
 * Read on, dear reader, and be amazed!
 */

#include <stdio.h>
#include <stdlib.h>

/*
 * A humble array of integers, awaiting their fate.
 */
int loot[] = { 1, 2, 5, 10, 20, 50, 100, 200, 500, 1000 };
int n_loot = sizeof(loot) / sizeof(loot[0]);

/*
 * The insatiable knapsack, eager to be filled with loot.
 */
int knapsack_size = 100;

/*
 * The all-seeing eye of the Greedy Algorithm, guiding our every step.
 */
void greedy_algorithm() {
  int i;
  int total_value = 0;
  int current_size = 0;

  /*
   * Behold! The Greedy Algorithm in all its glory!
   * It iterates through the loot array, adding the most valuable items first.
   */
  for (i = n_loot - 1; i >= 0; i--) {
    /*
     * Can we fit this item into the knapsack?
     */
    if (current_size + loot[i] <= knapsack_size) {
      /*
       * Yes! Let's grab it!
       */
      total_value += loot[i];
      current_size += loot[i];
    }
  }

  /*
   * The knapsack is full! Let's show off our ill-gotten gains.
   */
  printf("Total value of loot: %d\n", total_value);
}

int main() {
  /*
   * Summon the Greedy Algorithm and witness its power!
   */
  greedy_algorithm();

  return 0;
}