//GPT-4o-mini DATASET v1.0 Category: Poker Game ; Style: satisfied
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define NUM_CARDS 52
#define NUM_PLAYERS 2
#define HAND_SIZE 5

typedef struct {
    char *suits[4];
    char *ranks[13];
    int deck[NUM_CARDS];
} Game;

typedef struct {
    int hand[HAND_SIZE];
    int bet;
    char name[50];
} Player;

void initialize_game(Game *game) {
    game->suits[0] = "Hearts";
    game->suits[1] = "Diamonds";
    game->suits[2] = "Clubs";
    game->suits[3] = "Spades";

    game->ranks[0] = "2";
    game->ranks[1] = "3";
    game->ranks[2] = "4";
    game->ranks[3] = "5";
    game->ranks[4] = "6";
    game->ranks[5] = "7";
    game->ranks[6] = "8";
    game->ranks[7] = "9";
    game->ranks[8] = "10";
    game->ranks[9] = "J";
    game->ranks[10] = "Q";
    game->ranks[11] = "K";
    game->ranks[12] = "A";

    for(int i = 0; i < NUM_CARDS; i++) {
        game->deck[i] = i;
    }
}

void shuffle_deck(Game *game) {
    srand(time(NULL));
    for (int i = 0; i < NUM_CARDS; i++) {
        int j = rand() % NUM_CARDS;
        int temp = game->deck[i];
        game->deck[i] = game->deck[j];
        game->deck[j] = temp;
    }
}

void deal_hand(Game *game, Player *player) {
    for (int i = 0; i < HAND_SIZE; i++) {
        player->hand[i] = game->deck[i];
    }
}

void print_hand(Player *player, Game *game) {
    printf("%s's hand:\n", player->name);
    for (int i = 0; i < HAND_SIZE; i++) {
        int card = player->hand[i];
        printf("%s of %s\n", game->ranks[card % 13], game->suits[card / 13]);
    }
}

int compare_hands(Player *player1, Player *player2) {
    int player1_score = 0, player2_score = 0;

    for (int i = 0; i < HAND_SIZE; i++) {
        player1_score += (player1->hand[i] % 13) + 2; // base 2 for score
        player2_score += (player2->hand[i] % 13) + 2;
    }
    
    if (player1_score > player2_score) return 1; // player1 wins
    if (player1_score < player2_score) return -1; // player2 wins
    return 0; // tie
}

void ask_bet(Player *player) {
    printf("%s, enter your bet: ", player->name);
    scanf("%d", &player->bet);
}

void determine_winner(Player *player1, Player *player2) {
    int result = compare_hands(player1, player2);
    if (result == 1) {
        printf("%s wins!\n", player1->name);
    } else if (result == -1) {
        printf("%s wins!\n", player2->name);
    } else {
        printf("It's a tie!\n");
    }
}

int main() {
    Game game;
    Player players[NUM_PLAYERS];

    // Initialize game and players
    initialize_game(&game);
    shuffle_deck(&game);

    for (int i = 0; i < NUM_PLAYERS; i++) {
        printf("Enter the name for Player %d: ", i + 1);
        scanf("%s", players[i].name);
    }

    // Deal hands
    deal_hand(&game, &players[0]);
    deal_hand(&game, &players[1]);

    // Print hands
    print_hand(&players[0], &game);
    print_hand(&players[1], &game);

    // Players place bets
    for (int i = 0; i < NUM_PLAYERS; i++) {
        ask_bet(&players[i]);
    }

    // Determine winner
    determine_winner(&players[0], &players[1]);

    return 0;
}