//Gemma-7B DATASET v1.0 Category: Terminal Based Game ; Style: imaginative
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_MOVES 10
#define BOARD_SIZE 5

typedef struct Move {
  int x;
  int y;
  char direction;
} Move;

Move moves[MAX_MOVES];

void initializeMoves() {
  for (int i = 0; i < MAX_MOVES; i++) {
    moves[i].x = -1;
    moves[i].y = -1;
    moves[i].direction = '\0';
  }
}

void printBoard(int **board) {
  for (int i = 0; i < BOARD_SIZE; i++) {
    for (int j = 0; j < BOARD_SIZE; j++) {
      printf("%c ", board[i][j]);
    }
    printf("\n");
  }
}

int main() {

  int board[BOARD_SIZE][BOARD_SIZE] = {{'a', 'b', 'c', 'd', 'e'},
                              {'f', 'g', 'h', 'i', 'j'},
                              {'k', 'l', 'm', 'n', 'o'},
                              {'p', 'q', 'r', 's', 't'},
                              {'u', 'v', 'w', 'x', 'y'}};

  initializeMoves();

  srand(time(NULL));

  int currentMove = 0;

  while (currentMove < MAX_MOVES) {

    int x = rand() % BOARD_SIZE;
    int y = rand() % BOARD_SIZE;
    char direction = 'h';

    for (int i = 0; i < MAX_MOVES; i++) {
      if (moves[i].x == x && moves[i].y == y) {
        direction = 'a';
      }
    }

    moves[currentMove].x = x;
    moves[currentMove].y = y;
    moves[currentMove].direction = direction;

    currentMove++;

    printBoard(board);

    if (direction == 'a') {
      printf("Move not valid.\n");
    } else {
      printf("Move accepted.\n");
    }
  }

  return 0;
}