//GEMINI-pro DATASET v1.0 Category: Robot movement control ; Style: peaceful
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the robot's state
typedef enum {
    FORWARD,
    BACKWARD,
    LEFT,
    RIGHT,
    STOP
} robot_state;

// Define the robot's movement
typedef struct {
    float speed;
    robot_state state;
} robot_movement;

// Initialize the random number generator
void init_random() {
    srand(time(NULL));
}

// Generate a random movement
robot_movement generate_movement() {
    robot_movement movement;
    movement.speed = (float)(rand() % 10) / 10.0 + 0.1;
    movement.state = rand() % 5;
    return movement;
}

// Print the robot's movement
void print_movement(robot_movement movement) {
    printf("Speed: %.2f\n", movement.speed);
    switch (movement.state) {
        case FORWARD:
            printf("State: FORWARD\n");
            break;
        case BACKWARD:
            printf("State: BACKWARD\n");
            break;
        case LEFT:
            printf("State: LEFT\n");
            break;
        case RIGHT:
            printf("State: RIGHT\n");
            break;
        case STOP:
            printf("State: STOP\n");
            break;
    }
}

// Move the robot
void move_robot(robot_movement movement) {
    // Move the robot forward
    if (movement.state == FORWARD) {
        printf("Moving forward at %.2f m/s\n", movement.speed);
    }
    // Move the robot backward
    else if (movement.state == BACKWARD) {
        printf("Moving backward at %.2f m/s\n", movement.speed);
    }
    // Turn the robot left
    else if (movement.state == LEFT) {
        printf("Turning left at %.2f rad/s\n", movement.speed);
    }
    // Turn the robot right
    else if (movement.state == RIGHT) {
        printf("Turning right at %.2f rad/s\n", movement.speed);
    }
    // Stop the robot
    else if (movement.state == STOP) {
        printf("Stopping\n");
    }
}

// Main function
int main() {
    // Initialize the random number generator
    init_random();

    // Generate a random movement
    robot_movement movement = generate_movement();

    // Print the robot's movement
    print_movement(movement);

    // Move the robot
    move_robot(movement);

    return 0;
}