//Falcon-180B DATASET v1.0 Category: Greedy Algorithms ; Style: automated
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SIZE 1000

int main() {
    int n, i, j, max_size = 0, total_size = 0;
    char **items;

    printf("Enter the number of items: ");
    scanf("%d", &n);

    items = (char **)malloc(n * sizeof(char *));
    for (i = 0; i < n; i++) {
        items[i] = (char *)malloc(MAX_SIZE * sizeof(char));
        printf("Enter item %d: ", i + 1);
        scanf("%s", items[i]);
        if (strlen(items[i]) > max_size) {
            max_size = strlen(items[i]);
        }
        total_size += strlen(items[i]) + 1; // +1 for NULL terminator
    }

    printf("Max item size: %d\n", max_size);
    printf("Total item size: %d\n", total_size);

    int bin_size = total_size / max_size;
    if (total_size % max_size!= 0) {
        bin_size++;
    }

    printf("Number of bins: %d\n", bin_size);

    int *bin_sizes = (int *)malloc(bin_size * sizeof(int));
    for (i = 0; i < bin_size; i++) {
        bin_sizes[i] = max_size;
    }

    int current_bin = 0;
    for (i = 0; i < n; i++) {
        if (strlen(items[i]) <= bin_sizes[current_bin]) {
            strcat(items[current_bin], " ");
            strcat(items[current_bin], items[i]);
            strcat(items[current_bin], " ");
        } else {
            current_bin++;
            if (current_bin >= bin_size) {
                printf("Not enough bins to fit all items.\n");
                exit(1);
            }
        }
    }

    for (i = 0; i < bin_size; i++) {
        printf("Bin %d: %s\n", i + 1, items[i]);
    }

    for (i = 0; i < n; i++) {
        free(items[i]);
    }
    free(items);
    free(bin_sizes);

    return 0;
}