//MISTRAL-7B DATASET v1.0 Category: Table Game ; Style: irregular
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define ANIMAL_COUNT 6
#define DICE_COUNT 2

typedef struct Animal {
    char name[10];
    int point;
} Animal;

Animal animals[ANIMAL_COUNT] = {{"Lion", 10}, {"Elephant", 5}, {"Monkey", 8}, {"Giraffe", 3}, {"Zebra", 6}, {"Rhinoceros", 7}};

void roll_dice(int *dice) {
    for (int i = 0; i < DICE_COUNT; i++) {
        dice[i] = rand() % ANIMAL_COUNT;
        printf("Rolled %s\n", animals[dice[i]].name);
    }
}

int determine_winner(int *dice1, int *dice2) {
    int score1 = 0, score2 = 0;

    for (int i = 0; i < DICE_COUNT; i++) {
        score1 += animals[dice1[i]].point;
        score2 += animals[dice2[i]].point;
    }

    if (score1 > score2) {
        printf("Player 1 wins!\n");
        return 1;
    } else if (score1 < score2) {
        printf("Player 2 wins!\n");
        return 2;
    } else {
        printf("It's a tie!\n");
        return 0;
    }
}

int main() {
    int player1_dice[DICE_COUNT], player2_dice[DICE_COUNT];

    srand(time(NULL));

    printf("Welcome to Fuzzy Dice!\n");

    roll_dice(player1_dice);
    roll_dice(player2_dice);

    determine_winner(player1_dice, player2_dice);

    return 0;
}