//Falcon-180B DATASET v1.0 Category: Interprocess communication ; Style: optimized
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/wait.h>
#include <string.h>

#define BUF_SIZE 100

char *filename = "myfifo";

void child_process(char *message);

int main() {
    int fd[2];
    pid_t pid;

    // create the FIFO
    if (mkfifo(filename, 0666) == -1) {
        printf("Error creating FIFO\n");
        exit(1);
    }

    if (pipe(fd) == -1) {
        printf("Error creating pipe\n");
        exit(1);
    }

    // fork the child process
    pid = fork();

    if (pid == -1) {
        printf("Error forking\n");
        exit(1);
    } else if (pid > 0) {
        // parent process
        close(fd[0]);
        write(fd[1], "Hello from parent\n", 21);
        close(fd[1]);
        wait(NULL);
    } else {
        // child process
        close(fd[1]);
        char buffer[BUF_SIZE];
        read(fd[0], buffer, BUF_SIZE);
        child_process(buffer);
        close(fd[0]);
        exit(0);
    }

    return 0;
}

void child_process(char *message) {
    printf("Child received: %s\n", message);
    char response[BUF_SIZE];
    strcpy(response, "Hello from child\n");
    write(1, response, strlen(response));
}