//GEMINI-pro DATASET v1.0 Category: Memory management ; Style: configurable
#include <stdio.h>
#include <stdlib.h>

// Define the memory management functions
void* my_malloc(size_t size) {
    void* ptr = malloc(size);
    if (ptr == NULL) {
        fprintf(stderr, "Error: Could not allocate memory.\n");
        exit(EXIT_FAILURE);
    }
    return ptr;
}

void my_free(void* ptr) {
    free(ptr);
}

// Define the data structure
typedef struct {
    int x;
    int y;
} Point;

// Define the configuration options
#define MEMORY_MANAGEMENT_FUNCTION my_malloc
#define MEMORY_FREE_FUNCTION my_free

// Create a function to create a new point
Point* create_point(int x, int y) {
    Point* point = (Point*) MEMORY_MANAGEMENT_FUNCTION(sizeof(Point));
    point->x = x;
    point->y = y;
    return point;
}

// Create a function to free a point
void free_point(Point* point) {
    MEMORY_FREE_FUNCTION(point);
}

// Create a function to print a point
void print_point(Point* point) {
    printf("(%d, %d)\n", point->x, point->y);
}

// Create a function to main
int main() {
    Point* point = create_point(1, 2);
    print_point(point);
    free_point(point);
    return 0;
}