//Code Llama-13B DATASET v1.0 Category: Graph Coloring Problem ; Style: Claude Shannon
#include <stdio.h>
#include <stdlib.h>

#define MAX_VERTICES 100
#define MAX_EDGES 1000

typedef struct {
    int u;
    int v;
} Edge;

int graph[MAX_VERTICES][MAX_VERTICES];
int color[MAX_VERTICES];

void initialize_graph(int n) {
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < n; j++) {
            graph[i][j] = 0;
        }
    }
}

void add_edge(int u, int v) {
    graph[u][v] = 1;
    graph[v][u] = 1;
}

void color_graph(int n, int m) {
    for (int i = 0; i < n; i++) {
        color[i] = 0;
    }

    for (int i = 0; i < m; i++) {
        for (int j = 0; j < n; j++) {
            if (graph[i][j] == 1) {
                color[j] = 1;
            }
        }
    }
}

int main() {
    int n = 5;
    int m = 6;

    initialize_graph(n);

    add_edge(0, 1);
    add_edge(1, 2);
    add_edge(2, 3);
    add_edge(3, 4);
    add_edge(4, 0);

    color_graph(n, m);

    for (int i = 0; i < n; i++) {
        printf("%d ", color[i]);
    }

    return 0;
}