//GEMINI-pro DATASET v1.0 Category: GPS Navigation Simulation ; Style: excited
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Constants for the Earth's radius and the speed of light
const double EARTH_RADIUS = 6371000; // in meters
const double SPEED_OF_LIGHT = 299792458; // in meters per second

// Structure to represent a GPS satellite
typedef struct {
  double x; // x-coordinate in meters
  double y; // y-coordinate in meters
  double z; // z-coordinate in meters
  double clock_bias; // clock bias in seconds
} GPS_Satellite;

// Structure to represent a GPS receiver
typedef struct {
  double x; // x-coordinate in meters
  double y; // y-coordinate in meters
  double z; // z-coordinate in meters
  double clock_offset; // clock offset in seconds
} GPS_Receiver;

// Function to calculate the distance between two points on the Earth's surface
double distance(GPS_Satellite satellite, GPS_Receiver receiver) {
  double dx = satellite.x - receiver.x;
  double dy = satellite.y - receiver.y;
  double dz = satellite.z - receiver.z;
  return sqrt(dx * dx + dy * dy + dz * dz);
}

// Function to simulate the GPS navigation system
void gps_navigation(GPS_Satellite satellites[], GPS_Receiver receiver) {
  // Calculate the distance to each satellite
  double distances[4];
  for (int i = 0; i < 4; i++) {
    distances[i] = distance(satellites[i], receiver);
  }

  // Calculate the time of arrival of each signal
  double times[4];
  for (int i = 0; i < 4; i++) {
    times[i] = distances[i] / SPEED_OF_LIGHT;
  }

  // Calculate the receiver's clock offset
  double clock_offset = (times[0] + times[1] + times[2] + times[3]) / 4 - receiver.clock_offset;

  // Calculate the receiver's position
  double x = (distances[0] * distances[0] - distances[1] * distances[1] + distances[2] * distances[2] - distances[3] * distances[3]) / (2 * (satellites[0].x - satellites[1].x) * (satellites[2].x - satellites[3].x) - 2 * (satellites[0].x - satellites[2].x) * (satellites[1].x - satellites[3].x));
  double y = (distances[0] * distances[0] - distances[1] * distances[1] + distances[2] * distances[2] - distances[3] * distances[3]) / (2 * (satellites[0].y - satellites[1].y) * (satellites[2].y - satellites[3].y) - 2 * (satellites[0].y - satellites[2].y) * (satellites[1].y - satellites[3].y));
  double z = sqrt(distances[0] * distances[0] - (x - satellites[0].x) * (x - satellites[0].x) - (y - satellites[0].y) * (y - satellites[0].y));

  // Print the receiver's position
  printf("Receiver position: (%f, %f, %f)\n", x, y, z);
}

int main() {
  // Create four GPS satellites
  GPS_Satellite satellites[4] = {
    {EARTH_RADIUS, 0, 0, 0},
    {0, EARTH_RADIUS, 0, 0},
    {0, 0, EARTH_RADIUS, 0},
    {-EARTH_RADIUS, 0, 0, 0}
  };

  // Create a GPS receiver
  GPS_Receiver receiver = {0, 0, 0, 0};

  // Simulate the GPS navigation system
  gps_navigation(satellites, receiver);

  return 0;
}