//GPT-4o-mini DATASET v1.0 Category: Space Invaders Game Clone ; Style: energetic
#include <ncurses.h>
#include <stdlib.h>
#include <time.h>
#include <unistd.h>

#define WIDTH 30
#define HEIGHT 20

typedef struct {
    int x, y;
} Player;

typedef struct {
    int x, y;
    int alive;
} Alien;

typedef struct {
    int x, y;
    int active;
} Bullet;

Player player;
Alien aliens[5];
Bullet bullet;

void initialize();
void draw();
void update();
void shoot();
void move_aliens();
int check_collision();
void cleanup();

int main() {
    initialize();

    while (1) {
        clear();
        draw();
        update();
        if (check_collision()) {
            break;
        }
        usleep(30000); // control game speed
    }

    cleanup();
    return 0;
}

void initialize() {
    initscr();
    noecho();
    curs_set(FALSE);
    keypad(stdscr, TRUE);
    timeout(0); // non-blocking input

    player.x = WIDTH / 2;
    player.y = HEIGHT - 1;

    for (int i = 0; i < 5; i++) {
        aliens[i].x = i * 5 + 1;
        aliens[i].y = 0;
        aliens[i].alive = 1;
    }

    bullet.active = 0;

    srand(time(NULL));
}

void draw() {
    mvprintw(player.y, player.x, "A"); // Draw player

    for (int i = 0; i < 5; i++) {
        if (aliens[i].alive) {
            mvprintw(aliens[i].y, aliens[i].x, "V"); // Draw aliens
        }
    }

    if (bullet.active) {
        mvprintw(bullet.y, bullet.x, "|"); // Draw bullet
    }

    mvprintw(HEIGHT + 1, 0, "Use arrow keys to move left/right, space to shoot. Press 'q' to quit.");
    refresh();
}

void update() {
    int ch = getch();
    
    // Player control
    if (ch == KEY_LEFT && player.x > 0) {
        player.x--;
    } else if (ch == KEY_RIGHT && player.x < WIDTH - 1) {
        player.x++;
    } else if (ch == ' ' && !bullet.active) {
        shoot();
    } else if (ch == 'q') {
        exit(0);
    }

    // Update bullet position
    if (bullet.active) {
        bullet.y--;
        if (bullet.y < 0) {
            bullet.active = 0;
        }
    }

    // Move aliens down
    move_aliens();
}

void shoot() {
    bullet.x = player.x;
    bullet.y = player.y - 1;
    bullet.active = 1;
}

void move_aliens() {
    int move_down = 0;
    for (int i = 0; i < 5; i++) {
        if (aliens[i].alive) {
            aliens[i].y++;
            if (aliens[i].y >= player.y) {
                move_down = 1; // If an alien reaches the player line, it's game over
            }
        }
    }
    
    // Move down if necessary
    if (move_down) {
        // You can decide what to do here (e.g., exit game)
        // For now, we'll just print a message and exit the loop
        mvprintw(HEIGHT / 2, WIDTH / 2 - 10, "GAME OVER! Aliens reached you!");
        refresh();
        sleep(2);
        exit(0);
    }
}

int check_collision() {
    if (bullet.active) {
        for (int i = 0; i < 5; i++) {
            if (aliens[i].alive && aliens[i].x == bullet.x && aliens[i].y == bullet.y) {
                aliens[i].alive = 0; // Mark alien as dead
                bullet.active = 0; // Clear bullet
                return 0; // No collision
            }
        }
    }
    return 0; // No collision
}

void cleanup() {
    endwin(); // End ncurses mode
}